//
//  MCModelEditHUDDualView.h
//  MCApplication
//
//  Created by Ali Lalani on 10/15/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCHUDCanvas;
@interface MCModelEditHUDDualView : NSView {
	NSColor *borderColor;
	BOOL allowsResizing;	
	float _textViewSplitProportion;
	id model;

	BOOL _isTiling;

	BOOL _allowsSplitResizing;
	NSRect _splitRect;
	
	id delegate;
}
// toggles the edit mode on the text view
- (IBAction)toggleEditMode:(id)sender;

- (void)commonInit;
- (void)tile;
- (NSSize)minSizeForContentInTextView:(NSTextView *)tv;


#pragma mark Accessors
- (BOOL)allowsSplitResizing;
- (NSTextView *)textView;
- (MCHUDCanvas *)hudCanvas;

- (float)splitProportion;
- (void)setSplitProportion:(float)prop;
- (BOOL)allowsResizing;
- (void)setAllowsResizing:(BOOL)flag;
- (NSColor *)borderColor;
- (void)setBorderColor:(NSColor *)aBorderColor;
- (float)textViewSplitProportion;
- (void)setTextViewSplitProportion:(float)aTextViewSplitProportion;
- (id)model;
- (void)setModel:(id)aModel;
- (id)delegate;
- (void)setDelegate:(id)aDelegate;

@end

@interface NSObject (HUDDualViewDelegate)
- (void)dualViewSplitProportionDidChange:(MCModelEditHUDDualView *)self;
@end
